/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "gmsettingsclass.h"

#define PluginName "C4 Limit Separator Plugin"
#define PluginVersion "1.0"

struct ExampleSettingsStruct : public virtual SettingsLoader {
	ExampleSettingsStruct(const char *ININame) : SettingsLoader(ININame) {
		Var = true;
	}

	void Load();

	bool Var;
	std::vector<std::string> List;
};

void Plugin_Load();
void Plugin_Unload();

class Plugin_Example_Script : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
};

class Hooking
{
public:
	struct WideString
	{
		const wchar_t *wcs;
	};
	static bool ReadMemory(int Location, void* Buffer, int BufferLen);
	static bool WriteMemory(int Location, const void* Buffer, int BufferLen);
	static void PreInstall();
	static void Install();
	static void Uninstall();
};

class Hook
{
private:
	char Backup[20];
	char HookPadding[10];
	int HookAddress;
	int Offset;
	bool IsInstalled;
public:
	Hook()
	{
		Offset = 0;
		IsInstalled = false;
	}
	bool Install(char OpCode, int Addr, int Glue, char *Padding)
	{
		if (Addr && Glue && !IsInstalled)
		{
			HookAddress = Addr;
			memcpy(HookPadding,Padding,(sizeof(Padding) > sizeof(HookPadding) ? sizeof(HookPadding) : sizeof(Padding)));
			HookPadding[10] = '\0';
			Offset = Glue - HookAddress - 5;
			Hooking::ReadMemory(HookAddress, Backup, 5+strlen(Padding));
			Hooking::WriteMemory(HookAddress, &OpCode, 1);
			Hooking::WriteMemory(HookAddress+1, &Offset, 4);
			if (strlen(Padding) > 0)
			{
				Hooking::WriteMemory(HookAddress+5, &Padding, strlen(Padding));
			}
			IsInstalled = true;
			return true;
		}
		return false;
	};
	bool Uninstall()
	{
		if (IsInstalled)
		{
			Hooking::WriteMemory(HookAddress, Backup, 5+strlen(HookPadding));
			IsInstalled = false;
			return true;
		}
		return false;
	};
};

void Host_Hook(int ID, TextMessageEnum Type, const char *Msg);

class ArmorWarheadManager {
public:
	static const char *Get_Warhead_Name(int Warhead);
	static int Get_Warhead_Type(const char *);
	static float Get_Damage_Multiplier(unsigned int DefenseShield, unsigned int OffenseWarhead);
};
